
/************************************************************************
 *
 * \file: UsbDeviceId.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include "UsbDeviceId.h"

namespace adit { namespace aauto {

UsbDeviceId::UsbDeviceId(int inVendorId, const std::string& inSerial)
{
    vendorId = inVendorId;
    serial = inSerial;
}

bool UsbDeviceId::operator==(const UsbDeviceId& inRight) const
{
    return (vendorId == inRight.vendorId) && (serial == inRight.serial);
}

bool UsbDeviceId::operator<(const UsbDeviceId& inRight) const
{
    if (vendorId < inRight.vendorId)
        return true;
    if (serial < inRight.serial)
        return true;
    return false;
}

} } // namespace adit { namespace aauto {
